﻿Public Class frmSettings
    Private Sub frmSettings_Load(sender As Object, e As System.EventArgs) Handles Me.Load
        ' Einstellungen aus Registry lesen
        With Me
            .txtLiveID.Text = My.Settings.txtLiveID
            .txtLivePassword.Text = My.Settings.txtLivePassword
        End With

        ' Control-Status aktualisieren
        Call ControlStatus()
    End Sub

    Private Sub txtLivePassword_Enter(sender As Object, e As System.EventArgs) Handles txtLivePassword.Enter
        With Me.txtLivePassword
            .UseSystemPasswordChar = False
            .PasswordChar = Nothing
            .SelectAll()
        End With
    End Sub

    Private Sub txtLivePassword_Leave(sender As Object, e As System.EventArgs) Handles txtLivePassword.Leave
        With Me.txtLivePassword
            .UseSystemPasswordChar = True

            If .Focused Then
                Me.btnOK.Focus()
            End If
        End With
    End Sub

    Private Sub LogonSettings_Changed(sender As System.Object, e As System.EventArgs) Handles txtLiveID.TextChanged, txtLivePassword.TextChanged
        ' Control-Status aktualisieren
        Call ControlStatus()
    End Sub

    Private Sub btnOK_Click(sender As System.Object, e As System.EventArgs) Handles btnOK.Click
        ' Einstellungen in Registry schreiben
        With My.Settings
            .txtLiveID = Me.txtLiveID.Text
            .txtLivePassword = Me.txtLivePassword.Text
            .Save()
        End With

        ' Form schließen
        Me.Close()
    End Sub

    Private Sub btnCancel_Click(sender As System.Object, e As System.EventArgs) Handles btnCancel.Click
        ' Form schließen
        Me.Close()
    End Sub

    ' ******************************************************************************************
    ' Routinen
    ' ******************************************************************************************

    Private Sub ControlStatus()
        With Me
            ' OK-Button nur aktivieren, wenn beide Textfelder einen Inhalt haben
            .btnOK.Enabled = .txtLiveID.Text > "" And .txtLivePassword.Text > ""
        End With
    End Sub
End Class